 ; Ŀ
 ;   Sec - section arrow maker.                                            
 ;   Copyright 2000, 2010 by Rocket Software Ltd.                          
 ;   School (and university) rules:                                        
 ;   1. Think for yourself - don't just memorize things.                   
 ;   2. Just plug the numbers into the formula and the answer drops out.   
 ;   3. You're only here to learn how to learn.                            
 ;   4. If you don't memorise this you won't make it in the real world.    
 ;   5. The love of knowledge is the most important thing in life.         
 ;   6. School has to be tedious and unpleasant - it's good for you.       
 ; 

 ; Ŀ
 ;   Subroutine Angpt - find the inside angle indicated by three points.   
 ;   Takes the two line endpoints and the intersection as arguments,       
 ;   returns a list: the inside angle in radians and degrees.              
 ; 
 (DEFUN ANGPT (pta ptcom ptb / ang1 ang2 angg)
  (setq ang1 (angle ptcom pta))
  (setq ang2 (angle ptcom ptb))
  (if (> ang1 ang2)
      (setq angg (- ang1 ang2))
      (setq angg (- ang2 ang1)))
  (if (> angg pi)
      (setq angg (abs (- angg (* 2 pi)))))
  (list angg (/ (* 180 angg) pi)))         ; radians and degrees
 ; Ŀ
 ;   Angpt end.                                                            
 ; 

 ; Ŀ
 ;   Sec.                                                                  
 ; 
 (DEFUN C:SEC (/ scal pa pb angg direc ps)
  (setvar "cmdecho" 0)
  (setvar "blipmode" 0)
  (setvar "attdia" 0)
  (setvar "osmode" 0)
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
  (setq scal (misps))
  (setq pa (getpoint "Insertion point: "))
  (setq pb (getpoint pa "Other end: "))
  (setq angg (angle pa pb))
  (setq direc (getpoint pb "View direction: "))
 ; Ŀ
 ;   Decide which way to point the arrows.                                 
 ; 
  (if (>= (car (angpt direc pb (polar pb (+ angg (/ pi 2)) 10))) (/ pi 2))
      (setq direc (- angg (/ pi 2)))
      (setq direc (+ angg (/ pi 2))))
 ; Ŀ
 ;   Draw the polyline.                                                    
 ; 
  (command ".pline" (polar pa (+ angg pi) (* scal 7))
                    (polar pa (+ angg pi) (* scal 10))
                    (polar pa direc (* scal 11))
                    (polar pa angg (* scal 10))
                    (polar pa angg (* scal 7))
                    (setq ps (polar pb (+ angg pi) (* scal 10)))
                    "H" 0 (* scal 3)
                    (polar (polar ps angg (* scal 5)) direc (* scal 3.5))
                    "H" (* scal 3) 0 pb "")
 ; Ŀ
 ;   Insert the block, drop off the edge of the world into the abyss.      
 ; 
  (command ".insert" "section" pa scal "" "0")
 (princ))